using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;

namespace delta_of_build
{
	/// <summary>
	/// Summary description for Form2.
	/// </summary>
	public class Form2 : System.Windows.Forms.Form
	{
		public System.Windows.Forms.ListBox m_ListBuilds;
		private System.Windows.Forms.Button m_GetBuild;
		public string Path;
		public string FileDirectory = Directory.GetCurrentDirectory();
		
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form2()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			FileDirectory = String.Concat(FileDirectory,"\\System");
			string Line = null;
			StreamReader builds = File.OpenText(FileDirectory+"\\builds.txt");
			do
			{
				Line = ReadLineFromFile(builds);
				if(Line== null)
				{
					break;
				}
				this.m_ListBuilds.Items.Add(Line);				
			}while(Line != null);
			builds.Close();
			m_ListBuilds.SelectedIndex=0;
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		/// 

		public static string ReadLineFromFile(StreamReader SR)
		{
			
			string Input = null;
			Input = SR.ReadLine();
			return (Input);
		}	

		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form2));
			this.m_ListBuilds = new System.Windows.Forms.ListBox();
			this.m_GetBuild = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// m_ListBuilds
			// 
			this.m_ListBuilds.HorizontalScrollbar = true;
			this.m_ListBuilds.Location = new System.Drawing.Point(8, 8);
			this.m_ListBuilds.Name = "m_ListBuilds";
			this.m_ListBuilds.Size = new System.Drawing.Size(128, 238);
			this.m_ListBuilds.Sorted = true;
			this.m_ListBuilds.TabIndex = 0;
			this.m_ListBuilds.SelectedIndexChanged += new System.EventHandler(this.m_ListBuilds_SelectedIndexChanged);
			// 
			// m_GetBuild
			// 
			this.m_GetBuild.Font = new System.Drawing.Font("Monotype Corsiva", 24F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.m_GetBuild.Location = new System.Drawing.Point(160, 104);
			this.m_GetBuild.Name = "m_GetBuild";
			this.m_GetBuild.Size = new System.Drawing.Size(112, 48);
			this.m_GetBuild.TabIndex = 1;
			this.m_GetBuild.Text = "Get it";
			this.m_GetBuild.Click += new System.EventHandler(this.button1_Click);
			// 
			// Form2
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 266);
			this.Controls.Add(this.m_GetBuild);
			this.Controls.Add(this.m_ListBuilds);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "Form2";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "DeltaBuild - Build selection";
			this.Load += new System.EventHandler(this.Form2_Load);
			this.ResumeLayout(false);

		}
		#endregion



		private void Form2_Load(object sender, System.EventArgs e)
		{
			
		
		}

		public void DelTree( string root )
		{
			// Delete all files in current folder.
			foreach( string file in Directory.GetFiles( root ) )
			{
				File.SetAttributes( file ,FileAttributes.Normal);
				File.Delete( file ); 
			}

			// Loop thru all directories in current folder and do a recursive call. When the call returns, delete the folder
			foreach( string dir in Directory.GetDirectories( root ) ) 
			{
				DelTree( dir );
				Directory.Delete( dir , true);
			}
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			if(MessageBox.Show("This Operation will delete the choosen folder.\n    Please backup/checkin all your Work!\n              Continue with get Build? ","Attention", MessageBoxButtons.YesNo, MessageBoxIcon.Warning)==DialogResult.Yes)
			{
				DelTree(Path);

				Path="\""+Path+"\"";
				// Execution command-line
				string cmdLine;
				cmdLine = "\""+FileDirectory;
				cmdLine += "\\sync.wsf\"";
				cmdLine += " /LocalPath:"+Path+" /SyncType:Full /BuildID:"+m_ListBuilds.Text;
				System.Diagnostics.Process Process;
				Process = new System.Diagnostics.Process();
				Process = System.Diagnostics.Process.Start("wscript", cmdLine);
				Process.WaitForExit();
				if(Process.ExitCode!=0)
				{
					Application.ExitThread();
					
				}
				else
				{
					StreamWriter Last_Full_Get = File.CreateText(FileDirectory+"\\Last_Full_Get.txt");
					Last_Full_Get.WriteLine(m_ListBuilds.Text);
					Last_Full_Get.Close();
				}
			}			
		}

		public void writetoform2(string str)
		{
			Path=str;
		}

		private void m_ListBuilds_SelectedIndexChanged(object sender, System.EventArgs e)
		{
		
		}
	}
}
